import * as React from 'react';
import { Display } from '../../layout';
import { Background, StyledLayout } from '../../styled-layout';

export interface AccordionBodyProps {
  /**
   * @example Lorem ipsum dolor sit amet, consectetur adipiscing elit
   */
  children?: React.ReactNode;
  /**
   * @example true
   */
  isOpen?: boolean;
}

/**
 * AccordionBody is a content region whose visibility should be
 * controlled by an AccordionHeader
 */
export const AccordionBody: React.SFC<AccordionBodyProps> = (props) => (
  <StyledLayout
    padding={2}
    background={Background.Alt}
    elevation={1}
    display={props.isOpen ? Display.Block : Display.HideAccessible}
  >
    {props.children}
  </StyledLayout>
);

AccordionBody.displayName = 'AccordionBody';
