import * as React from 'react';
import { StyledLayout } from '../../styled-layout';
import { AccordionBody, AccordionBodyProps } from '../accordion-body';
import { AccordionFooter, AccordionFooterProps } from '../accordion-footer';
import { AccordionHeader, AccordionHeaderProps } from '../accordion-header';

export type AccordionItem = {
  header: AccordionHeaderProps;
  body: AccordionBodyProps;
  footer?: AccordionFooterProps;
};

export interface AccordionProps {
  items: AccordionItem[];
}

export interface State {
  currentOpenIndex: number;
}

/**
 * Accordion is used to consistently compose and control some accordion items
 * which will each be composed of an AccordionHeader, AccordionBody, and AccordionFooter
 */
export class Accordion extends React.Component<AccordionProps, State> {
  public state = {
    currentOpenIndex: 0,
  };

  public render() {
    return (
      <StyledLayout>
        {this.props.items.map((item, index) => (
          <StyledLayout borderBottom={index !== this.state.currentOpenIndex} key={index}>
            <AccordionHeader
              {...item.header}
              isOpen={index === this.state.currentOpenIndex}
              onClick={this.onHeaderClick}
              index={index}
            />

            <AccordionBody {...item.body} isOpen={index === this.state.currentOpenIndex}>
              {item.body.children}
              {item.footer && <AccordionFooter {...item.footer} />}
            </AccordionBody>
          </StyledLayout>
        ))}
      </StyledLayout>
    );
  }

  public onHeaderClick = (_EVENT: React.MouseEvent<HTMLElement>, index?: number) => {

    if (typeof index === 'number') {
      this.setState({
        currentOpenIndex: index,
      });
    }
  }

}
