import { setupShallowTest } from '../../tests/helpers';
import { ButtonIcon } from '../button/button-icon/component';
import {
  AlertBanner,
  AlertBannerProps,
  AlertBannerType,
} from './component';

const mockCallback = jest.fn();

function getRequiredProps(): AlertBannerProps {
  return {
    closeButtonAriaLabel: 'Close',
    type: AlertBannerType.Info,
    message: 'Alert Banner Info Bar',
    onCloseButtonClick: mockCallback,
  };
}

function getOptionalProps(): AlertBannerProps {
  return {
    closeButtonAriaLabel: 'Close',
    onCloseButtonClick: jest.fn(),
    type: AlertBannerType.Info,
    status: 'Alert',
    message: 'Alert Banner Info Bar',
    link: {
      to: '//twitch.tv',
      children: 'Link CTA',
    },
    actions:
      [
        { children: 'Confirm' },
        { children: 'Dismiss' },
      ],
  };
}

const setupShallow = setupShallowTest(AlertBanner, getRequiredProps);

describe('Alert Banner', () => {
  it('renders alert-banner component', () => {
    const { wrapper } = setupShallow();

    expect(wrapper).toMatchSnapshot();
  });

  it('renders alert-banner component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());

    expect(wrapper).toMatchSnapshot();
  });

  it('fires the onCloseButtonClick callback when the user clicks the close button', () => {
    const { wrapper } = setupShallow();

    // Simulate onCloseButtonClick and verify it calls the mock callback
    wrapper.find(ButtonIcon).simulate('click');
    expect(mockCallback.mock.calls.length).toEqual(1);
  });
});
