import { setupShallowTest } from '../../tests/helpers';
import {
  Align,
  Aspect,
  AspectProps,
  AspectRatio,
} from './component';

function getOptionalProps(): AspectProps {
  return {
    ratio: AspectRatio.Aspect16x9,
    align: Align.Bottom,
    overflow: true,
  };
}

const setupShallow = setupShallowTest(Aspect);

describe('Aspect', () => {
  it('renders apect component', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders apect component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
