import { setupShallowTest } from '../../tests/helpers';
import { PresenceStatus } from '../presence';
import { BorderRadius } from '../styled-layout';
import {
  Avatar,
  AvatarProps,
} from './component';

const AVATAR_SIZE = 30;
const AVATAR_ALT = 'Test alt string';
const AVATAR_URL = 'testURL';

function getRequiredProps(): AvatarProps {
  return {
    size: AVATAR_SIZE,
    alt: AVATAR_ALT,
  };
}

function getOptionalProps(): AvatarProps {
  return {
    borderRadius: BorderRadius.Medium,
    size: AVATAR_SIZE,
    alt: AVATAR_ALT,
    src: AVATAR_URL,
    onError: jest.fn(),
    onLoad: jest.fn(),
    presenceIndicator: true,
    presenceStatus: PresenceStatus.Online,
  };
}

const setupShallow = setupShallowTest(Avatar, getRequiredProps);

describe('Avatar', () => {
  it('renders avatar component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders avatar component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
