import { setupShallowTest } from '../../tests/helpers';
import { Background } from '../styled-layout';
import {
  Balloon,
  BalloonDirection,
  BalloonProps,
  BalloonSize,
} from './component';

const BALLOON_OFFSET = '2rem';
const BALOON_ELEVATION = 3;
const BALLOON_TAIL_OFFSET = 20;

function getOptionalProps(): BalloonProps {
  return {
    direction: BalloonDirection.RightCenter,
    elevation: BALOON_ELEVATION,
    noTail: true,
    offsetX: BALLOON_OFFSET,
    offsetY: BALLOON_OFFSET,
    show: true,
    size: BalloonSize.Medium,
    tailBackground: Background.Alt2,
    tailOffset: BALLOON_TAIL_OFFSET,
  };
}

const setupShallow = setupShallowTest(Balloon);

describe('Balloon', () => {
  it('renders balloon component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders balloon component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
