import { setupShallowTest } from '../../../tests/helpers';
import { SVGAsset } from '../../svg';
import {
  ButtonIcon,
  ButtonIconProps,
  ButtonIconSize,
  ButtonIconType,
} from './component';

function getOptionalProps(): ButtonIconProps {
  return {
    ariaLabel: 'Test aria label',
    autoFocus: true,
    blurAfterClick: true,
    disabled: true,
    download: 'Download all the things',
    dropdown: true,
    linkTo: '/',
    icon: SVGAsset.Gear,
    onClick: jest.fn(),
    overlay: true,
    size: ButtonIconSize.Large,
    statusAlertIcon: SVGAsset.Friends,
    tabIndex: 0,
    targetBlank: true,
    title: 'test title',
    type: ButtonIconType.Hollow,
  };
}

const setupShallow = setupShallowTest(ButtonIcon);
describe('ButtonIcon', () => {
  it('renders button icon component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders button icon component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders button icon component as <a>', () => {
    const { wrapper } = setupShallow({ linkTo: 'https://www.google.com' });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders button icon component <button> with an onclick', () => {
    const { wrapper } = setupShallow({ onClick: jest.fn() });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders button icon component as Link component', () => {
    const { wrapper } = setupShallow({ linkTo: '/dashbaord' });
    expect(wrapper).toMatchSnapshot();
  });
});
