import { setupShallowTest } from '../../../tests/helpers';
import { SVGAsset } from '../../svg';
import {
  Button,
  ButtonProps,
  ButtonSize,
  ButtonState,
  ButtonType,
} from './component';

function getOptionalProps(): ButtonProps {
  return {
    ariaLabel: 'Test aria label',
    autoFocus: true,
    blurAfterClick: true,
    disabled: true,
    download: 'Download all the things',
    dropdown: true,
    fullWidth: true,
    linkTo: '/',
    state: ButtonState.Loading,
    icon: SVGAsset.Gear,
    onClick: jest.fn(),
    overlay: true,
    purchase: '$9.99',
    size: ButtonSize.Large,
    statusAlertIcon: SVGAsset.Friends,
    statusAlertText: 'Status alert text',
    tabIndex: 0,
    targetBlank: true,
    title: 'test title',
    type: ButtonType.Hollow,
  };
}

const setupShallow = setupShallowTest(Button);
describe('Button', () => {
  it('renders button component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders button component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders button component as <a>', () => {
    const { wrapper } = setupShallow({ linkTo: 'www.google.com' });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders button component as <button> with an onclick', () => {
    const { wrapper } = setupShallow({ onClick: jest.fn() });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders button component as Link component', () => {
    const { wrapper } = setupShallow({ linkTo: '/dashbaord' });
    expect(wrapper).toMatchSnapshot();
  });
});
