import * as React from 'react';
import { getDataProps } from '../../../utils/data-props';
import { Layout, Overflow, Position } from '../../layout';

export interface CardBodyProps {
  overflow?: Overflow;
  children?: React.ReactNode;
}

export const CardBody: React.SFC<CardBodyProps> = (props) => {
  return (
    <Layout className="tw-card-body" overflow={props.overflow} position={Position.Relative} {...getDataProps(props)}>
      {props.children}
    </Layout>
  );
};

CardBody.displayName = 'CardBody';
