import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import { getImageProps } from '../../../utils/image-props';
import { Aspect, AspectRatio } from '../../aspect';
import { CoreImage, CoreImageProps } from '../../core-image';
import { Overflow } from '../../layout';
import { BorderRadius, StyledLayout } from '../../styled-layout';
import './styles.scss';

export enum CardImageSize {
  Default = 'tw-card-img--size-default',
  Size2 = 'tw-card-img--size-2',
  Size3 = 'tw-card-img--size-3',
  Size4 = 'tw-card-img--size-4',
  Size6 = 'tw-card-img--size-6',
  Size8 = 'tw-card-img--size-8',
  Size12 = 'tw-card-img--size-12',
  Size16 = 'tw-card-img--size-16',
  Size24 = 'tw-card-img--size-24',
  Size32 = 'tw-card-img--size-32',
}

export interface CardImageProps extends CoreImageProps {
  aspect?: AspectRatio;
  borderRadius?: BorderRadius;
  children?: React.ReactNode;
  size?: CardImageSize;
  overflow?: boolean;
}

export const CardImage: React.SFC<CardImageProps> = (props) => {
  const classes: ClassValue = {
    'tw-card-img': true,
  };

  if (props.size && props.size !== CardImageSize.Default) {
    classes[props.size] = true;
  }

  return (
    <StyledLayout
      className={cn(classes)}
      flexShrink={0}
      borderRadius={props.borderRadius}
      overflow={Overflow.Hidden}
      {...getDataProps(props)}
    >
      <Aspect ratio={props.aspect ? props.aspect : AspectRatio.Aspect16x9} overflow={props.overflow}>
        <CoreImage
          {...getImageProps(props)}
        />
      </Aspect>
      {props.children}
    </StyledLayout>
  );
};

CardImage.displayName = 'CardImage';
