import * as React from 'react';
import { cn } from '../../utils/classnames';
import { getDataProps } from '../../utils/data-props';
import { Display, Layout, Position } from '../layout';
import './styles.scss';

export enum ChannelStatusIndicatorSize {
  Small = 'tw-channel-status-indicator--small',
  Medium = 'tw-channel-status-indicator--medium',
  Large = 'tw-channel-status-indicator--large',
}

export enum ChannelStatusIndicatorStatus {
  Offline = 'tw-channel-status-indicator--offline',
  Hosting = 'tw-channel-status-indicator--hosting',
  Live = 'tw-channel-status-indicator--live',
}

export interface ChannelStatusIndicatorProps {
  /** The size of the channel status indicator. */
  size?: ChannelStatusIndicatorSize;
  pulse?: boolean;
  /** The status of the indicator. */
  status?: ChannelStatusIndicatorStatus;
}

/**
 * Displays an element that helps to communicate the status of a channel. This
 * element relies on color, so it must be used in addition to text to
 * adequately indicate the status of the channel.
 */
export const ChannelStatusIndicator: React.SFC<ChannelStatusIndicatorProps> = (props) => {
  const classes: ClassValue = {
    'tw-channel-status-indicator': true,
    'tw-channel-status-indicator--pulse': props.pulse,
  };

  if (props.size) {
    classes[props.size] = true;
  } else {
    classes[ChannelStatusIndicatorSize.Small] = true;
  }

  if (props.status) {
    classes[props.status] = true;
  } else {
    classes[ChannelStatusIndicatorStatus.Offline] = true;
  }

  return <Layout display={Display.InlineBlock} position={Position.Relative} className={cn(classes)} {...getDataProps(props)}/>;
};

ChannelStatusIndicator.displayName = 'ChannelStatusIndicator';
