import { setupShallowTest } from '../../tests/helpers';
import {
  CoreImage,
  CoreImageProps,
} from './component';

function getRequiredProps(): CoreImageProps {
  return {
    src: 'testSrc',
    alt: 'Test alt',
  };
}

function getOptionalProps(): CoreImageProps {
  return {
    src: 'testSrc',
    alt: 'Test alt',
    srcSet: {
      '1x': 'https://placehold.jp/6441a4/ffffff/200x100.jpg?text=1x',
      '1.5x': 'https://placehold.jp/6441a4/ffffff/300x150.jpg?text=1.5x',
      '2x': 'https://placehold.jp/6441a4/ffffff/400x200.jpg?text=2x',
      '3x': 'https://placehold.jp/6441a4/ffffff/600x300.jpg?text=3x',
      '4x': 'https://placehold.jp/6441a4/ffffff/800x400.jpg?text=4x',
    },
    sizes: [
      { size: '400px', mediaCondition: '(min-width: 400px)' },
      { size: '100vw' },
    ],
    onError: jest.fn(),
    onLoad: jest.fn(),
  };
}

const setupShallow = setupShallowTest(CoreImage, getRequiredProps);
describe('CoreImage', () => {
  it('renders core image component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders core image component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('sets src attribute as sizes > srcSet > src', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    const imageProps = wrapper.find('img').props();

    let foundSrc = false;
    let foundSrcSet = false;

    Object.keys(imageProps).forEach((key) => {
      if (key === 'src') {
        foundSrc = true;
      }

      if (key === 'srcSet') {
        foundSrcSet = true;
        expect(foundSrc).toEqual(false);
      }

      if (key === 'sizes') {
        expect(foundSrc).toEqual(false);
        expect(foundSrcSet).toEqual(false);
      }
    });
  });
});
