import { setupShallowTest } from '../../tests/helpers';
import { CoreInteractive } from './component';

const setupShallow = setupShallowTest(CoreInteractive);
describe('CoreInteractive', () => {
  it('renders core interactive component defaulting as <button>', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders core interactive component with all (non-custom link) props as a disabled <button>', () => {
    const { wrapper } = setupShallow({
      ariaLabel: 'a link to something',
      autoFocus: true,
      blurAfterClick: true,
      className: 'myClass',
      children: 'text',
      disabled: true,
      download: 'download',
      linkTo: 'https://example.com',
      onClick: jest.fn(),
      refHandler: jest.fn(),
      role: 'role',
      tabIndex: 1,
      targetBlank: true,
      title: 'test title',
    });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders core interactive component with linkTo, download, and non-disabled props as <a>', () => {
    const { wrapper } = setupShallow({ children: 'text', linkTo: 'https://example.com', title: 'test title' });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders core interactive component with internal linkTo and non-disabled props as react-router Link component', () => {
    const { wrapper } = setupShallow({ children: 'text', linkTo: '/somewhere', title: 'test title' });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders a core interactive component and passes the replace prop to react-router Link', () => {
    const { wrapper } = setupShallow({ children: 'text', linkTo: '/somewhere', replace: true });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders core interactive component with renderLink and internal linkTo props as custom link component', () => {
    const props = {
      linkTo: 'home',
      renderLink: jest.fn().mockReturnValue('this could be anything'),
      title: 'test title',
    };

    const { wrapper } = setupShallow(props);
    expect(wrapper).toMatchSnapshot();
    expect(props.renderLink).toHaveBeenCalledWith(props);
  });
});
