import { setupShallowTest } from '../../tests/helpers';
import {
  CoreLink,
  CoreLinkProps,
  CoreLinkType,
} from './component';

function getOptionalProps(): CoreLinkProps {
  return {
    className: 'test-classname',
    type: CoreLinkType.Overlay,
    onClick: jest.fn(),
    to: '/',
    hoverUnderlineNone: true,
    targetBlank: true,
    disabled: true,
    title: 'test',
  };
}

const setupShallow = setupShallowTest(CoreLink);
describe('CoreLink', () => {
  it('renders core link component with required props as <button>', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders core link component with all props as <a>', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
