import * as history from 'history';
import * as React from 'react';
import { cn } from '../../utils/classnames';
import { getDataProps } from '../../utils/data-props';
import { CoreInteractive, CoreInteractivePublicProps } from '../core-interactive';
import './styles.scss';

export interface CoreLinkProps extends CoreInteractivePublicProps {
  /**
   * @example Link Text
   */
  children?: React.ReactNode;
  className?: string;
  /**
   * Sets display variant type. Overlay for usage on images or masks; Inherit to inherit text color for default display.
   */
  type?: CoreLinkType;
  /**
   * Indicates the element is a link and will navigate to the passed URL.
   * @deprecated use linkTo instead
   */
  to?: history.LocationDescriptor;
  /**
   * Determines whether the link shows an underline.
   */
  underline?: boolean;
  /**
   * Determines whether the link shows an underline on hover.
   */
  hoverUnderlineNone?: boolean;
  /**
   * Text color to set on hover.
   */
  hoverColorInherit?: boolean;
}

export enum CoreLinkType {
  Default = '',
  Inherit = 'tw-link--inherit',
  Overlay = 'tw-link--overlay',
}

export class CoreLink extends React.Component<CoreLinkProps, {}> {
  public static defaultProps = {
    blurAfterClick: true,
  };

  public render() {
    return (
      <CoreInteractive
        {...this.props}
        className={this.className}
        linkTo={this.props.linkTo || this.props.to}
        {...getDataProps(this.props)}
      >
        {this.props.children}
      </CoreInteractive>
    );
  }

  private get className() {
    const classes: ClassValue = {
      'tw-link': true,
      'tw-link--underline': this.props.underline,
      'tw-link--disabled': this.props.disabled,
      'tw-link--hover-underline-none': this.props.hoverUnderlineNone,
      'tw-link--hover-color-inherit': this.props.hoverColorInherit,
      'tw-link--button': !this.props.to,
    };

    if (this.props.type) {
      classes[this.props.type] = true;
    }

    return cn(this.props.className, classes);
  }
}
