import { AriaCurrent, AriaHasPopup, AriaInvalid, AriaLive, AriaRelevant, AriaRole } from '../../aria/aria';
import { setupShallowTest } from '../../tests/helpers';
import { VerticalAlign } from '../layout';
import {
  Color,
  CoreText,
  CoreTextProps,
  FontSize,
  LineHeight,
  TextDecoration,
  TextTransform,
  TextType,
  WordBreak,
} from './component';

function getOptionalProps(): CoreTextProps {
  return {
    align: VerticalAlign.TextBottom,
    bold: true,
    breakpointExtraSmall: { fontSize: FontSize.Size1 },
    breakpointSmall: { fontSize: FontSize.Size2 },
    breakpointMedium: { fontSize: FontSize.Size3 },
    breakpointLarge: { fontSize: FontSize.Size4 },
    breakpointExtraLarge: { fontSize: FontSize.Size5 },
    breakpointExtraExtraLarge: { fontSize: FontSize.Size6 },
    className: 'test-classname',
    color: Color.Error,
    decoration: TextDecoration.Strikethrough,
    ellipsis: true,
    fontSize: FontSize.Size3,
    italic: true,
    lineHeight: LineHeight.Body,
    lines: 2,
    noWrap: true,
    strikethrough: true,
    title: 'Test title',
    transform: TextTransform.Uppercase,
    type: TextType.H3,
    wordBreak: WordBreak.KeepAll,
    role: AriaRole.Tree,
    ariaAtomic: true,
    ariaBusy: true,
    ariaControls: 'controls',
    ariaCurrent: AriaCurrent.Time,
    ariaDescribedby: 'described-by',
    ariaDetails: 'details',
    ariaDisabled: true,
    ariaErrormessage: 'error-message',
    ariaFlowto: 'flow-to',
    ariaHaspopup: AriaHasPopup.Dialog,
    ariaHidden: true,
    ariaInvalid: AriaInvalid.Spelling,
    ariaKeyshortcuts: 'key-shortcuts',
    ariaLabel: 'label',
    ariaLabelledby: 'labelled-by',
    ariaLive: AriaLive.Assertive,
    ariaOwns: 'owns',
    ariaRelevant: AriaRelevant.Text,
    ariaRoledescription: 'role-description',
  };
}

const setupShallow = setupShallowTest(CoreText);
describe('CoreText', () => {
  it('renders core text component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders core text component with all props as an h3', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
