import * as React from 'react';
import { getDataProps } from '../../../utils/data-props';
import { CheckBox } from '../../form/checkbox';
import { InputControlProps } from '../../form/form';
import { Radio } from '../../form/radio';
import { AlignItems, Display, Layout } from '../../layout';
import { SVG, SVGAsset } from '../../svg';

export enum DropDownMenuInputItemType {
  CheckBox = 1,
  Radio,
}

export interface DropDownMenuInputItemProps extends InputControlProps {
  type: DropDownMenuInputItemType;
  icon?: SVGAsset;
}

export const DropDownMenuInputItem: React.SFC<DropDownMenuInputItemProps> = (props) => {
  return (
    <Layout
      padding={0.5}
      display={Display.Flex}
      alignItems={AlignItems.Center}
      {...getDataProps(props)}
    >
      <Layout flexGrow={1}>
        {props.type === DropDownMenuInputItemType.CheckBox ? (
          <CheckBox {...props} />
        ) : (
          <Radio {...props} />
        )}
      </Layout>
      {props.icon && <SVG asset={props.icon} />}
    </Layout>
  );
};

DropDownMenuInputItem.displayName = 'DropDownMenuInputItem';
