import { setupShallowTest } from '../../../tests/helpers';
import { CoreImage } from '../../core-image';
import { SVGAsset } from '../../svg';
import {
  DropDownMenuItem,
  DropDownMenuItemProps,
} from './component';

function getRequiredProps(): DropDownMenuItemProps {
  return {
    title: 'Test title',
  };
}

function getOptionalProps(): DropDownMenuItemProps {
  return {
    title: 'Test Label',
    figure: SVGAsset.NavGames,
  };
}

const setupShallow = setupShallowTest(DropDownMenuItem, getRequiredProps);

describe('DropDownMenuItem', () => {
  it('renders drop down menu item component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders drop down menu item component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders drop down menu item component with an image', () => {
    const { wrapper } = setupShallow({
      figure: {
        alt: 'Aatrox avatar',
        src: 'https://ddragon.leagueoflegends.com/cdn/8.17.1/img/champion/Aatrox.png',
      },
    });
    expect(wrapper.find(CoreImage)).toHaveLength(1);
  });
});
