import { mount } from 'enzyme';
import * as React from 'react';
import { setupShallowTest } from '../../../tests/helpers';
import { BalloonDirection, BalloonSize } from '../../balloon';
import { CheckBox } from '../../form/checkbox';
import { Radio } from '../../form/radio';
import { DropDownMenuInputItemType } from '../drop-down-menu-input-item';
import {
  DropDownMenu,
  DropDownMenuProps,
} from './component';

const items = [
  { title: 'Test Item 1' },
  { title: 'Test Item 2' },
  { title: 'Test Item 3' },
];

function getRequiredProps(): DropDownMenuProps {
  return {
    items,
  };
}

function getOptionalProps(): DropDownMenuProps {
  return {
    items,
    direction: BalloonDirection.TopLeft,
    elevation: 1,
    maxHeight: '50vh',
    offsetX: '1rem',
    offsetY: '1rem',
    size: BalloonSize.Large,
    show: true,
  };
}

const setupShallow = setupShallowTest(DropDownMenu, getRequiredProps);

describe('DropDownMenu', () => {
  it('renders drop down menu component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders drop down menu component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders drop down menu component with checkboxes ', () => {
    const wrapper = mount(
      <DropDownMenu
        items={[
          { type: DropDownMenuInputItemType.CheckBox, label: 'Checkbox 1' },
          { type: DropDownMenuInputItemType.CheckBox, label: 'Checkbox 2' },
          { type: DropDownMenuInputItemType.CheckBox, label: 'Checkbox 3' },
        ]}
      />,
    );

    expect(wrapper.find(CheckBox)).toHaveLength(3);
  });

  it('renders drop down menu component with radios ', () => {
    const wrapper = mount(
      <DropDownMenu
        items={[
          { type: DropDownMenuInputItemType.Radio, label: 'Radio 1' },
          { type: DropDownMenuInputItemType.Radio, label: 'Radio 2' },
        ]}
      />,
    );

    expect(wrapper.find(Radio)).toHaveLength(2);
  });
});
