import * as React from 'react';
import { Balloon, BalloonDirection, BalloonSize } from '../../balloon';
import { Display, FlexDirection, InjectLayout, Layout, Overflow } from '../../layout';
import { Elevation } from '../../styled-layout';
import { DropDownMenuInputItem, DropDownMenuInputItemProps } from '../drop-down-menu-input-item';
import { DropDownMenuItem, DropDownMenuItemProps } from '../drop-down-menu-item';

export type DropDownMenuList = DropDownMenuInputItemProps[] | DropDownMenuItemProps[];
export type DropDownMenuDirection = BalloonDirection.TopLeft | BalloonDirection.TopRight | BalloonDirection.BottomLeft | BalloonDirection.BottomRight;

export interface DropDownMenuProps {
  items: DropDownMenuList;
  direction?: DropDownMenuDirection;
  elevation?: Elevation;
  maxHeight?: string;
  offsetX?: string;
  offsetY?: string;
  size?: BalloonSize;
  show?: boolean;
}

export class DropDownMenu extends React.Component<DropDownMenuProps, {}> {
  public render () {
    let content: JSX.Element[] = [];

    if (isDropDownMenuInputItems(this.props.items)) {
      content = this.props.items.map((item, index) => <DropDownMenuInputItem {...item} key={index} /> );
    }

    if (isDropDownMenuItems(this.props.items)) {
      content = this.props.items.map((item, index) => <DropDownMenuItem key={index} {...item} />);
    }

    return (
      <Balloon
        elevation={this.props.elevation}
        offsetX={this.props.offsetX}
        offsetY={this.props.offsetY}
        direction={this.props.direction}
        size={this.props.size ? this.props.size : BalloonSize.Small}
        show={this.props.show}
      >
        <InjectLayout display={Display.Flex} flexDirection={FlexDirection.Column}>
          <div style={{ maxHeight: this.props.maxHeight }}>
            <Layout overflow={Overflow.Auto} padding={1}>
              {content}
            </Layout>
          </div>
        </InjectLayout>
      </Balloon>
    );
  }
}

function isDropDownMenuInputItems(arg: DropDownMenuList): arg is DropDownMenuInputItemProps[] {
  // If there is anything in this array missing the `type` property,
  // return false.
  return (arg as DropDownMenuInputItemProps[]).find((item) => (item.type === undefined)) === undefined;
}

function isDropDownMenuItems (arg: DropDownMenuList): arg is DropDownMenuItemProps[] {
  // If there is anything in this array missing the `title` property,
  // return false.
  return (arg as DropDownMenuItemProps[]).find((item) => (item.title === undefined)) === undefined;
}
