import * as React from 'react';
import { cn } from '../../utils/classnames';
import { getDataProps } from '../../utils/data-props';
import { AlignItems, Display, JustifyContent, Layout, Position } from '../layout';
import './styles.scss';

export interface DropZoneProps {
  /**
   * Children
   */
  children?: React.ReactNode;
  /** Provide feedback when the element is dragged over. */
  dragOver?: boolean;
  /** Provide feedback when an error occurs. */
  error?: boolean;
  /** Display the element as disabled – remove ability to interact with it. */
  disabled?: boolean;
}

/**
 * This component provides an interface for drag and drop inputs.
 */
export const DropZone: React.SFC<DropZoneProps> = (props) => {
  const classes: ClassValue = {
    'tw-drop-zone': true,
    'tw-drop-zone--over': props.dragOver,
    'tw-drop-zone--error': props.error,
    'tw-drop-zone--disabled': props.disabled,
  };

  return (
    <Layout
      className={cn(classes)}
      {...getDataProps(props)}
      alignItems={AlignItems.Center}
      display={Display.Flex}
      fullHeight
      fullWidth
      justifyContent={JustifyContent.Center}
      position={Position.Absolute}
      attachTop
      attachLeft
    >
      <div className="tw-drop-zone__content">
        {props.children}
      </div>
    </Layout>
  );
};

DropZone.displayName = 'DropZone';
