import * as React from 'react';
import { Background, Column, CoreImage, EditorialDetail, Grid, GridGutterSize, Layout } from '../..';

export interface EditorialBannerProps {

    /**
     * Main text content to be shown
     * @example Discover dark and brutal tombs
     */
    title: string;

    /**
     * Main image showcasing content
     * @example https://m.media-amazon.com/images/G/01//mchenryz/ExportedImage._CB1198675309_.png
     */
    imageSrc: string;

    /**
     * Text used for accessible that describes the image being shown
     * @example Dark image showcasing Tomb Raider content
     */
    imageAlt?: string;

    /**
     * Subtext for the content
     * @example In Shadow of the Tomb Raider, Lara must master a deadly jungle, overcome terrifying tombs, and persevere through her darkest hour.
     */
    subtitle?: string;

}

/**
 * Banner to show content along with text for an explanation
 */
export const EditorialBanner: React.SFC<EditorialBannerProps> = (props) => {
    return (
      <Layout
        className="sm-offer-editorial"
        fullHeight={true}
      >
        <Grid gutterSize={GridGutterSize.None}>
            <Column cols={{ default: 12, sm: 8 }}>
                <CoreImage src={props.imageSrc} alt={props.imageAlt || 'Content Image'} fullHeight fullWidth/>
            </Column>
            <Column cols={{ default: 12, sm: 4 }}>
                <EditorialDetail title={props.title} subtitle={props.subtitle} backgroundColor={Background.AccentAlt2}/>
            </Column>
        </Grid>
      </Layout>
    );
};
