import { Background } from '../..';
import { setupShallowTest } from '../../tests/helpers';
import {
  EditorialDetail,
  EditorialDetailProps,
  testSelectors,
} from './component';

const title = 'Discover dark and brutal tombs';

function getRequiredProps(): EditorialDetailProps {
  return {
    title,
  };
}

const setupShallow = setupShallowTest(EditorialDetail, getRequiredProps);

describe('renders Editorial Detail with title', () => {
  it('renders alert-banner component', () => {
    const { wrapper } = setupShallow();

    expect(wrapper.find({ 'data-test-target': testSelectors.title }).contains(title)).toBeTruthy();
    expect(wrapper.find({ 'data-test-target': testSelectors.wrapper }).prop('background')).toEqual(Background.Accent);
  });

  it('renders alert-banner component with subtitle', () => {
    const subtitle = 'In Shadow of the Tomb Raider, Lara must master a deadly jungle, overcome terrifying tombs, and persevere through her darkest hour.';
    const { wrapper } = setupShallow({
      subtitle,
    });

    expect(wrapper.find({ 'data-test-target': testSelectors.title }).contains(title)).toBeTruthy();
    expect(wrapper.find({ 'data-test-target': testSelectors.subtitle }).contains(subtitle)).toBeTruthy();
    expect(wrapper.find({ 'data-test-target': testSelectors.wrapper }).prop('background')).toEqual(Background.Accent);
  });

  it('renders alert-banner component with subtitle and background', () => {
    const subtitle = 'In Shadow of the Tomb Raider, Lara must master a deadly jungle, overcome terrifying tombs, and persevere through her darkest hour.';
    const { wrapper } = setupShallow({
      subtitle,
      backgroundColor: Background.AccentAlt2,
    });

    expect(wrapper.find({ 'data-test-target': testSelectors.title }).contains(title)).toBeTruthy();
    expect(wrapper.find({ 'data-test-target': testSelectors.subtitle }).contains(subtitle)).toBeTruthy();
    expect(wrapper.find({ 'data-test-target': testSelectors.wrapper }).prop('background')).toEqual(Background.AccentAlt2);
  });
});
