import { setupShallowTest } from '../../../tests/helpers';
import { InputSize } from '../form';
import {
  CheckBox,
  CheckBoxProps,
} from './component';

function getRequiredProps(): CheckBoxProps {
  return {
    label: 'Test Label',
    id: 'test-id',
  };
}

function getOptionalProps(): CheckBoxProps {
  return {
    autoFocus: true,
    checked: true,
    defaultChecked: true,
    disabled: true,
    error: true,
    id: 'test-id',
    label: 'Test Label',
    name: 'Test name',
    onBlur: jest.fn(),
    onChange: jest.fn(),
    onFocus: jest.fn(),
    required: true,
    tabIndex: 0,
    value: 'Test value',
  };
}

const setupShallow = setupShallowTest(CheckBox, getRequiredProps);

describe('CheckBox', () => {
  it('renders checkbox component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders checkbox component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders a checkbox component with size prop', () => {
    const { wrapper } = setupShallow({ size: InputSize.Large });
    expect(wrapper).toMatchSnapshot();
  });
});
