import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import { newUUIDv4 } from '../../../utils/unique-id';
import { StyledLayout } from '../../styled-layout';
import { INPUT_SIZES, InputControlProps, InputSize } from '../form';
import './styles.scss';

export interface CheckBoxProps extends InputControlProps {
  size?: InputSize;
}

export const CheckBox: React.SFC<CheckBoxProps> = (props) => {
  const generatedId = newUUIDv4();
  const classes: ClassValue = {
    'tw-checkbox': true,
    'tw-checkbox--error': props.error,
  };

  let tabIndex: number | undefined;
  if (props.tabIndex) {
    tabIndex = props.tabIndex;
  }

  let inputSize = InputSize.Default;
  if (props.size) {
    inputSize = props.size;
  }

  return (
    <StyledLayout
      className={cn(classes)}
      fontSize={INPUT_SIZES[inputSize]}
      {...getDataProps(props)}
    >
      <input
        className="tw-checkbox__input"
        type="checkbox"
        data-a-target="tw-checkbox"
        checked={props.checked}
        defaultChecked={props.defaultChecked}
        disabled={props.disabled}
        id={props.id ? props.id : generatedId}
        name={props.name}
        onBlur={props.onBlur}
        onChange={props.onChange}
        onFocus={props.onFocus}
        ref={props.refDelegate}
        readOnly={props.readOnly}
        required={props.required}
        tabIndex={tabIndex}
        value={props.value}
      />
      <label
        className="tw-checkbox__label"
        htmlFor={props.id ? props.id : generatedId}
      >
        {props.label}
      </label>
    </StyledLayout>
  );
};

CheckBox.displayName = 'CheckBox';
