import * as React from 'react';
import { Color, CoreText, FontSize, TextType } from '../../core-text';

export interface FormErrorProps {
  /**
   * @example The value you entered is invalid.
   */
  errorMessage: string;
}

export const FormError: React.SFC<FormErrorProps> = (props) => {

  return (
    <CoreText
      type={TextType.P}
      fontSize={FontSize.Size7}
      color={Color.Error}
    >
      *{props.errorMessage}
    </CoreText>
  );
};

FormError.displayName = 'FormError';
