import { setupShallowTest } from '../../../tests/helpers';
import {
  FormGroup,
  FormGroupOrientation,
  FormGroupProps,
} from './component';

function getRequiredProps(): FormGroupProps {
  return {
    label: 'Test Label',
    id: 'test-id',
  };
}

function getOptionalProps(): FormGroupProps {
  return {
    error: true,
    errorMessage: 'Error message',
    hint: 'Test hint',
    label: 'Test Label',
    id: 'test-id',
    labelOptional: 'Test optional label',
    orientation: FormGroupOrientation.Vertical,
  };
}

const setupShallow = setupShallowTest(FormGroup, getRequiredProps);

describe('FormGroup', () => {
  it('renders form group component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders form group component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
