import { setupShallowTest } from '../../../tests/helpers';
import { InputSize } from '../form';
import {
  FormTag,
  FormTagProps,
} from './component';

function getRequiredProps(): FormTagProps {
  return {
    label: 'Test Label',
  };
}

function getOptionalProps(): FormTagProps {
  return {
    disabled: true,
    label: 'Test Label',
    onClick: jest.fn(),
    selected: true,
    tabIndex: 0,
  };
}

const setupShallow = setupShallowTest(FormTag, getRequiredProps);

describe('FormTag', () => {
  it('renders form tag component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders form tag component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders form tag component with size prop', () => {
    const { wrapper } = setupShallow({ size: InputSize.Large });
    expect(wrapper).toMatchSnapshot();
  });
});
