import { FontSize } from '../core-text';

export interface InputControlProps {
  autoFocus?: boolean;
  /** Programatically check the box. */
  checked?: boolean;
  defaultChecked?: boolean;
  /** Display as disabled. */
  disabled?: boolean;
  error?: boolean;
  id?: string;
  /**
   * @example PlayStation 4
   */
  label: string;
  name?: string;
  onBlur?: React.FormEventHandler<HTMLInputElement>;
  onChange?: React.FormEventHandler<HTMLInputElement>;
  onFocus?: React.FormEventHandler<HTMLInputElement>;
  refDelegate?: (e: HTMLInputElement) => void;
  readOnly?: boolean;
  required?: boolean;
  tabIndex?: number;
  value?: string;
}

export enum InputSize {
  Default = 1,
  Large,
}

export const INPUT_SIZES = {
  [InputSize.Default]: FontSize.Size6,
  [InputSize.Large]: FontSize.Size4,
};
