import * as React from 'react';
import { Color, CoreText, FontSize, TextType } from '../../core-text';

export interface FormHintProps {
  /**
   * @example Any combination of letters or numbers
   */
  hint: string;
}

export const FormHint: React.SFC<FormHintProps> = (props) => {

  return (
    <CoreText
      type={TextType.P}
      fontSize={FontSize.Size7}
      color={Color.Alt2}
    >
      {props.hint}
    </CoreText>
  );
};

FormHint.displayName = 'FormHint';
