import { setupShallowTest } from '../../../tests/helpers';
import {
  ImageSelector,
  ImageSelectorProps,
  ImageSelectorType,
} from './component';

function getRequiredProps(): ImageSelectorProps {
  return {
    label: 'Test Label',
    id: 'test-id',
    src: '/testSRC',
    alt: 'Test Alt',
    type: ImageSelectorType.Radio,
  };
}

function getOptionalProps(): ImageSelectorProps {
  return {
    autoFocus: true,
    checked: true,
    defaultChecked: true,
    disabled: true,
    error: true,
    id: 'test-id',
    label: 'Test Label',
    name: 'Test name',
    onBlur: jest.fn(),
    onChange: jest.fn(),
    onFocus: jest.fn(),
    required: true,
    src: '/testSRC',
    alt: 'Test Alt',
    tabIndex: 0,
    type: ImageSelectorType.Checkbox,
    value: 'Test value',
  };
}

const setupShallow = setupShallowTest(ImageSelector, getRequiredProps);

describe('ImageSelector', () => {
  it('renders checkbox component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders checkbox component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
