import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import { getImageProps } from '../../../utils/image-props';
import { newUUIDv4 } from '../../../utils/unique-id';
import { CoreImage, CoreImageProps } from '../../core-image';
import { Display, InjectLayout } from '../../layout';
import { InputControlProps } from '../form';
import './styles.scss';

export enum ImageSelectorType {
  Checkbox = 'checkbox',
  Radio = 'radio',
}
export interface ImageSelectorProps extends CoreImageProps, InputControlProps {
  /** ImageSelectors can behave a radio or checkbox controls. */
  type: ImageSelectorType;
}

export const ImageSelector: React.SFC<ImageSelectorProps> = (props) => {
  const generatedId = newUUIDv4();
  const classes: ClassValue = {
    'tw-image-selector': true,
    'tw-image-selector--error': props.error,
  };

  let tabIndex: number | undefined;
  if (props.tabIndex) {
    tabIndex = props.tabIndex;
  }

  return (
    <div className={cn(classes)} {...getDataProps(props)}>
      <input
        className="tw-image-selector__input"
        type={props.type}
        data-a-target="tw-image-selector"
        checked={props.checked}
        defaultChecked={props.defaultChecked}
        disabled={props.disabled}
        id={props.id ? props.id : generatedId}
        name={props.name}
        onBlur={props.onBlur}
        onChange={props.onChange}
        onFocus={props.onFocus}
        ref={props.refDelegate}
        required={props.required}
        tabIndex={tabIndex}
        value={props.value}
      />
      <InjectLayout padding={0.5} display={Display.Block}>
        <label
          className="tw-image-selector__label"
          htmlFor={props.id ? props.id : generatedId}
        >
          <CoreImage
            {...getImageProps(props)}
          />
        </label>
      </InjectLayout>
    </div>
  );
};

ImageSelector.displayName = 'ImageSelector';
