import { setupShallowTest } from '../../../tests/helpers';
import { SVGAsset } from '../../svg';
import { InputSize } from '../form';
import {
  Input,
  InputProps,
  InputType,
} from './component';

function getRequiredProps(): InputProps {
  return {
    type: InputType.Password,
  };
}

function getOptionalProps(): InputProps {
  return {
    ariaLabel: 'Test aria label',
    autoCapitalize: true,
    autoComplete: 'true',
    autoCorrect: true,
    autoFocus: true,
    disabled: true,
    error: true,
    icon: SVGAsset.Gear,
    iconRight: true,
    id: 'test-id',
    list: 'list',
    maxLength: 100,
    name: 'Test name',
    onBlur: jest.fn(),
    onChange: jest.fn(),
    onClick: jest.fn(),
    onFocus: jest.fn(),
    onKeyDown: jest.fn(),
    placeholder: 'Test placeholder',
    readOnly: true,
    required: true,
    spellCheck: true,
    tabIndex: 0,
    min: 1,
    max: 100,
    step: 2,
    type: InputType.Password,
    value: 'Test Value',
    defaultValue: 'Default Value',
  };
}

const setupShallow = setupShallowTest(Input, getRequiredProps);

describe('Input', () => {
  it('renders input component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders input component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders input component with size prop', () => {
    const { wrapper } = setupShallow({ size: InputSize.Large });
    expect(wrapper).toMatchSnapshot();
  });
});
