import { setupShallowTest } from '../../../tests/helpers';
import {
  FormLabel,
  FormLabelProps,
} from './component';

function getRequiredProps(): FormLabelProps {
  return {
    label: 'Test Label',
    id: 'test-id',
  };
}

function getOptionalProps(): FormLabelProps {
  return {
    label: 'Test Label',
    id: 'test-id',
    required: true,
  };
}

const setupShallow = setupShallowTest(FormLabel, getRequiredProps);

describe('Label', () => {
  it('renders form label component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders form label component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
