import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { FormRequired } from '../required';
import './styles.scss';

export interface FormLabelProps {
  id: string;
  label: string;
  required?: boolean;
}

export const FormLabel: React.SFC<FormLabelProps> = (props) => {

  let requiredLabel: JSX.Element | undefined;

  if (props.required) {
    requiredLabel = <FormRequired/>;
  }

  const classes: ClassValue = {
    'tw-form-label': true,
  };

  return (
    <label className={cn(classes)} htmlFor={props.id}>
      {requiredLabel}{props.label}
    </label>
  );
};

FormLabel.displayName = 'FormLabel';
