import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { FormRequired } from '../required';
import './styles.scss';

export interface FormLegendProps {
  label: string;
  required?: boolean;
}

export const FormLegend: React.SFC<FormLegendProps> = (props) => {

  let requiredLegend: JSX.Element | undefined;

  if (props.required) {
    requiredLegend = (
      <FormRequired/>
    );
  }

  const classes: ClassValue = {
    'tw-form-legend': true,
  };

  return (
    <legend className={cn(classes)}>
      {requiredLegend}{props.label}
    </legend>
  );
};

FormLegend.displayName = 'FormLegend';
