import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import { newUUIDv4 } from '../../../utils/unique-id';
import { StyledLayout } from '../../styled-layout';
import { INPUT_SIZES, InputControlProps, InputSize } from '../form';
import './styles.scss';

export interface RadioProps extends InputControlProps {
  size?: InputSize;
}

export const Radio: React.SFC<RadioProps> = (props) => {
  const generatedId = `tw-${newUUIDv4()}`;
  const classes: ClassValue = {
    'tw-radio': true,
    'tw-radio--error': props.error,
  };

  let tabIndex: number | undefined;
  if (props.tabIndex) {
    tabIndex = props.tabIndex;
  }

  let inputSize = InputSize.Default;
  if (props.size) {
    inputSize = props.size;
  }

  return (
    <StyledLayout
      className={cn(classes)}
      fontSize={INPUT_SIZES[inputSize]}
      {...getDataProps(props)}
    >
      <input
        type="radio"
        className="tw-radio__input"
        data-a-target="tw-radio"
        autoFocus={props.autoFocus}
        checked={props.checked}
        defaultChecked={props.defaultChecked}
        disabled={props.disabled}
        id={props.id ? props.id : generatedId}
        name={props.name}
        onBlur={props.onBlur}
        onChange={props.onChange}
        onFocus={props.onFocus}
        readOnly={props.readOnly}
        required={props.required}
        ref={props.refDelegate}
        tabIndex={tabIndex}
        value={props.value}
      />
      <label
        className="tw-radio__label"
        htmlFor={props.id ? props.id : generatedId}
      >
        {props.label}
      </label>
    </StyledLayout>
  );
};

Radio.displayName = 'Radio';
