import { setupShallowTest } from '../../../tests/helpers';
import {
  Range,
  RangeProps,
} from './component';

function getOptionalProps(): RangeProps {
  return {
    disabled: true,
    defaultValue: '2',
    error: true,
    id: 'Test ID',
    name: 'Test name',
    onBlur: jest.fn(),
    onChange: jest.fn(),
    onFocus: jest.fn(),
    max: 100,
    min: 0,
    step: 10,
    tabIndex: 0,
    value: '2',
  };
}

const setupShallow = setupShallowTest(Range);

describe('Range', () => {
  it('renders range component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders range component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
