import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import './styles.scss';

export interface RangeProps {
  disabled?: boolean;
  defaultValue?: string;
  error?: boolean;
  id?: string;
  name?: string;
  onBlur?: React.FormEventHandler<HTMLInputElement>;
  onChange?: React.FormEventHandler<HTMLInputElement>;
  onFocus?: React.FormEventHandler<HTMLInputElement>;
  max?: number;
  min?: number;
  refDelegate?: (e: HTMLInputElement) => void;
  step?: number;
  tabIndex?: number;
  value?: string;
}

export const Range: React.SFC<RangeProps> = (props) => {
  const classes: ClassValue = {
    'tw-range': true,
    'tw-range--error': props.error,
  };

  let tabIndex: number | undefined;
  if (props.tabIndex) {
    tabIndex = props.tabIndex;
  }

  return (
    <input
      className={cn(classes)}
      id={props.id}
      onBlur={props.onBlur}
      onChange={props.onChange}
      onFocus={props.onFocus}
      tabIndex={tabIndex}
      defaultValue={props.defaultValue}
      disabled={props.disabled}
      type="range"
      min={props.min}
      max={props.max}
      name={props.name}
      ref={props.refDelegate}
      step={props.step}
      value={props.value}
      {...getDataProps(props)}
    />
  );
};

Range.displayName = 'Range';
