import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import { newUUIDv4 } from '../../../utils/unique-id';
import { Display, InjectLayout } from '../../layout';
import { SVGAsset } from '../../svg';
import { InputSize } from '../form';
import { Input, InputType } from '../input';
import './styles.scss';

export interface SearchInputProps {
  autoCapitalize?: boolean;
  autoFocus?: boolean;
  disabled?: boolean;
  id?: string;
  error?: boolean;
  maxLength?: number;
  name?: string;
  onBlur?: React.FormEventHandler<HTMLInputElement>;
  onChange?: React.FormEventHandler<HTMLInputElement>;
  onFocus?: React.FormEventHandler<HTMLInputElement>;
  onKeyDown?: React.KeyboardEventHandler<HTMLInputElement>;
  placeholder?: string;
  refDelegate?: (e: HTMLInputElement) => void;
  size?: InputSize;
  spellCheck?: boolean;
  tabIndex?: number;
  value?: string;
}

export const SearchInput: React.SFC<SearchInputProps> = (props) => {
  const generatedId = `tw-${newUUIDv4()}`;

  let tabIndex: number | undefined;
  if (props.tabIndex) {
    tabIndex = props.tabIndex;
  }

  return (
    <div className={cn('tw-search-input')} {...getDataProps(props)}>
      <InjectLayout display={Display.HideAccessible}>
        <label htmlFor={props.id ? props.id : generatedId}>Search</label>
      </InjectLayout>
      <Input
        autoCapitalize={props.autoCapitalize}
        autoFocus={props.autoFocus}
        autoComplete="off"
        disabled={props.disabled}
        error={props.error}
        icon={SVGAsset.NavSearch}
        id={props.id ? props.id : generatedId}
        maxLength={props.maxLength}
        name={props.name}
        onBlur={props.onBlur}
        onChange={props.onChange}
        onFocus={props.onFocus}
        onKeyDown={props.onKeyDown}
        placeholder={props.placeholder}
        refDelegate={props.refDelegate}
        spellCheck={props.spellCheck}
        tabIndex={tabIndex}
        size={props.size}
        type={InputType.Search}
        value={props.value}
      />
    </div>
  );
};

SearchInput.displayName = 'SearchInput';
