import { setupShallowTest } from '../../../../tests/helpers';
import {
  SegmentedButtonOption,
  SegmentedButtonOptionProps,
  SegmentedButtonType,
} from './component';

function getRequiredProps(): SegmentedButtonOptionProps {
  return {
    label: 'Test Label',
    name: 'Test name',
  };
}

function getOptionalProps(): SegmentedButtonOptionProps {
  return {
    checked: true,
    defaultChecked: true,
    defaultValue: 'Default Value',
    disabled: true,
    id: 'Test ID',
    label: 'Test Label',
    name: 'Test name',
    onBlur: jest.fn(),
    onChange: jest.fn(),
    onFocus: jest.fn(),
    tabIndex: 0,
    type: SegmentedButtonType.Checkbox,
    value: 'Test value',
  };
}

const setupShallow = setupShallowTest(SegmentedButtonOption, getRequiredProps);

describe('SegmentedButton', () => {
  it('renders segmented button option component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders segmented button option component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
