import * as React from 'react';
import { cn } from '../../../../utils/classnames';
import { getDataProps } from '../../../../utils/data-props';
import './styles.scss';

export enum SegmentedButtonType {
  Radio = 'radio',
  Checkbox = 'checkbox',
}

export interface SegmentedButtonOptionProps {
  checked?: boolean;
  defaultChecked?: boolean;
  defaultValue?: string;
  disabled?: boolean;
  id?: string;
  /**
   * @example Option
   */
  label: string;
  name: string;
  onBlur?: React.FormEventHandler<HTMLInputElement>;
  onChange?: React.FormEventHandler<HTMLInputElement>;
  onFocus?: React.FormEventHandler<HTMLInputElement>;
  refDelegate?: (e: HTMLInputElement) => void;
  tabIndex?: number;
  type?: SegmentedButtonType;
  value?: string;
}

export const SegmentedButtonOption: React.SFC<SegmentedButtonOptionProps> = (props) => {
  const classes: ClassValue = {
    'tw-segmented-button-option': true,
  };

  let tabIndex: number | undefined;
  if (props.tabIndex) {
    tabIndex = props.tabIndex;
  }

  return (
    <label className={cn(classes)} htmlFor={props.id} {...getDataProps(props)}>
      <input
        type={props.type || 'radio'}
        className="tw-segmented-button-option__input"
        checked={props.checked}
        defaultChecked={props.defaultChecked}
        defaultValue={props.defaultValue}
        disabled={props.disabled}
        id={props.id}
        name={props.name}
        onBlur={props.onBlur}
        onChange={props.onChange}
        onFocus={props.onFocus}
        tabIndex={tabIndex}
        ref={props.refDelegate}
        value={props.value}
        data-a-target="tw-segmented-button-option"
      />
      <span className="tw-segmented-button-option__label">{props.label}</span>
    </label>
  );
};

SegmentedButtonOption.displayName = 'SegmentedButtonOption';
