import * as React from 'react';
import { cn } from '../../../../utils/classnames';
import { getDataProps } from '../../../../utils/data-props';
import './styles.scss';

export interface SegmentedButtonProps {
  /**
   * @example <SegmentedButtonOption label="Chart" name="graph-view" />
   *  <SegmentedButtonOption label="Table" name="graph-view" />
   */
  children?: React.ReactNode;
}

export const SegmentedButton: React.SFC<SegmentedButtonProps> = (props) => {
  return (
    <div className={cn('tw-segmented-button')} {...getDataProps(props)}>
      {props.children}
    </div>
  );
};

SegmentedButton.displayName = 'SegmentedButton';
