import { setupShallowTest } from '../../../tests/helpers';
import { InputSize } from '../form';
import {
  Select,
  SelectProps,
  SelectType,
} from './component';

function getOptionalProps(): SelectProps {
  return {
    defaultValue: 'Default value',
    disabled: true,
    error: true,
    id: 'Test ID',
    name: 'Test name',
    onBlur: jest.fn(),
    onChange: jest.fn(),
    onFocus: jest.fn(),
    required: true,
    tabIndex: 0,
    type: SelectType.Hollow,
    value: 'Test value',
  };
}

const setupShallow = setupShallowTest(Select);

describe('Select', () => {
  it('renders select component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders select component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders select component with size prop', () => {
    const { wrapper } = setupShallow({ size: InputSize.Large });
    expect(wrapper).toMatchSnapshot();
  });
});
