import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import { Display } from '../../layout';
import { BorderRadius, InjectStyledLayout } from '../../styled-layout';
import { INPUT_SIZES, InputSize } from '../form';
import './styles.scss';

export interface SelectProps {
  children?: React.ReactNode;
  defaultValue?: string;
  disabled?: boolean;
  error?: boolean;
  id?: string;
  name?: string;
  onBlur?: React.FormEventHandler<HTMLSelectElement>;
  onChange?: React.FormEventHandler<HTMLSelectElement>;
  onFocus?: React.FormEventHandler<HTMLSelectElement>;
  refDelegate?: (e: HTMLSelectElement) => void;
  required?: boolean;
  tabIndex?: number;
  size?: InputSize;
  type?: SelectType;
  value?: string;
}

export enum SelectType {
  Default = '',
  Hollow = 'tw-select--hollow',
}

export const Select: React.SFC<SelectProps> = (props) => {
  const classes: ClassValue = {
    'tw-select': true,
    'tw-select--disabled': props.disabled,
    'tw-select--error': props.error,
  };

  if (props.type) {
    classes[props.type] = true;
  }

  let tabIndex: number | undefined;
  if (props.tabIndex) {
    tabIndex = props.tabIndex;
  }

  let inputSize = InputSize.Default;
  if (props.size) {
    inputSize = props.size;
  }

  return (
    <InjectStyledLayout
      display={Display.Block}
      borderRadius={BorderRadius.Medium}
      fontSize={INPUT_SIZES[inputSize]}
      padding={{ left: 1, y: 0.5, right: 3 }}
      fullWidth
    >
      <select
        className={cn(classes)}
        defaultValue={props.defaultValue}
        disabled={props.disabled}
        id={props.id}
        name={props.name}
        onBlur={props.onBlur}
        onChange={props.onChange}
        onFocus={props.onFocus}
        required={props.required}
        tabIndex={tabIndex}
        value={props.value}
        ref={props.refDelegate}
        {...getDataProps(props)}
      >
        {props.children}
      </select>
    </InjectStyledLayout>
  );
};

Select.displayName = 'Select';
