import { setupShallowTest } from '../../../tests/helpers';
import {
  Toggle,
  ToggleProps,
} from './component';

function getOptionalProps(): ToggleProps {
  return {
    autoFocus: true,
    checked: true,
    defaultValue: 'Default value',
    disabled: true,
    error: true,
    id: 'Test ID',
    name: 'Test name',
    onBlur: jest.fn(),
    onChange: jest.fn(),
    onFocus: jest.fn(),
    tabIndex: 0,
    value: 'Test value',
  };
}

const setupShallow = setupShallowTest(Toggle);

describe('Toggle', () => {
  it('renders toggle area component with required props', () => {
    const { wrapper } = setupShallow({ id: 'Test ID' });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders toggle area component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
