import * as React from 'react';
import { BorderRadius, InjectStyledLayout } from '../../..';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import { newUUIDv4 } from '../../../utils/unique-id';
import './styles.scss';

export interface ToggleProps {
  autoFocus?: boolean;
  checked?: boolean;
  defaultValue?: string;
  disabled?: boolean;
  error?: boolean;
  id?: string;
  name?: string;
  onBlur?: React.FormEventHandler<HTMLInputElement>;
  onChange?: React.FormEventHandler<HTMLInputElement>;
  onFocus?: React.FormEventHandler<HTMLInputElement>;
  refDelegate?: (e: HTMLInputElement) => void;
  tabIndex?: number;
  value?: string;
}

export const Toggle: React.SFC<ToggleProps> = (props) => {
  const generatedId = newUUIDv4();
  const classes: ClassValue = {
    'tw-toggle': true,
    'tw-toggle--error': props.error,
  };

  let tabIndex: number | undefined;
  if (props.tabIndex) {
    tabIndex = props.tabIndex;
  }

  return (
    <div className={cn(classes)} {...getDataProps(props)}>
      <input
        className="tw-toggle__input"
        autoFocus={props.autoFocus}
        checked={props.checked}
        defaultValue={props.defaultValue}
        disabled={props.disabled}
        id={props.id ? props.id : generatedId}
        name={props.name}
        onBlur={props.onBlur}
        onChange={props.onChange}
        onFocus={props.onFocus}
        tabIndex={tabIndex}
        type="checkbox"
        ref={props.refDelegate}
        value={props.value}
        data-a-target="tw-toggle"
      />
      <InjectStyledLayout borderRadius={BorderRadius.Medium}>
        <label htmlFor={props.id ? props.id : generatedId} className="tw-toggle__button" />
      </InjectStyledLayout>
    </div>
  );
};

Toggle.displayName = 'Toggle';
