import { setupShallowTest } from '../../../tests/helpers';
import {
  Column,
  ColumnOrder,
  ColumnProps,
} from './component';

function getRequiredProps(): ColumnProps {
  return {
    cols: 2,
  };
}

function getOptionalProps(): ColumnProps {
  return {
    cols: {
      default: 2,
      xs: 3,
      sm: 4,
      md: 5,
      lg: 6,
      xl: 7,
      xxl: 8,
    },
    offset: {
      default: 2,
      xs: 3,
      sm: 4,
      md: 5,
      lg: 6,
      xl: 7,
      xxl: 8,
    },
    order: {
      default: ColumnOrder.First,
      xs: ColumnOrder.Last,
      sm: ColumnOrder.First,
      md: ColumnOrder.Last,
      lg: ColumnOrder.First,
      xl: ColumnOrder.Last,
      xxl: ColumnOrder.First,
    },
  };
}

const setupShallow = setupShallowTest(Column, getRequiredProps);

describe('Column', () => {
  it('renders column component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders column component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
