import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import { AlignItems, JustifyContent, Layout } from '../../layout';
import './styles.scss';

export enum GridGutterSize {
  Default = '',
  Small = 'tw-grid--gutter-sm',
  Medium = 'tw-grid--gutter-md',
  Large = 'tw-grid--gutter-lg',
  None = 'tw-grid--gutter-none',
}

export interface GridBreakpointProps {
  alignItems?: AlignItems;
  justifyContent?: JustifyContent;
}

export interface GridProps extends GridBreakpointProps {
  /**
   * @example
   *   <Column cols={4}>
   *     <StyledLayout background={Background.Accent} padding={2} />
   *   </Column>
   *   <Column cols={4}>
   *     <StyledLayout background={Background.Accent} padding={2} />
   *   </Column>
   *   <Column cols={4}>
   *     <StyledLayout background={Background.Accent} padding={2} />
   *   </Column>
   */
  children?: React.ReactNode;
  fullHeight?: boolean;
  gutterSize?: GridGutterSize;
  breakpointExtraSmall?: GridBreakpointProps;
  breakpointSmall?: GridBreakpointProps;
  breakpointMedium?: GridBreakpointProps;
  breakpointLarge?: GridBreakpointProps;
  breakpointExtraLarge?: GridBreakpointProps;
  breakpointExtraExtraLarge?: GridBreakpointProps;
}

export const Grid: React.SFC<GridProps> = (props) => {
  const classes: ClassValue = {
    'tw-grid': true,
  };

  if (props.gutterSize) {
    classes[props.gutterSize] = true;
  }

  return (
    <Layout
      alignItems={props.alignItems}
      fullHeight={props.fullHeight}
      justifyContent={props.justifyContent}
      breakpointExtraSmall={props.breakpointExtraSmall}
      breakpointSmall={props.breakpointSmall}
      breakpointMedium={props.breakpointMedium}
      breakpointLarge={props.breakpointLarge}
      breakpointExtraLarge={props.breakpointExtraLarge}
      breakpointExtraExtraLarge={props.breakpointExtraExtraLarge}
      className={cn(classes)}
      {...getDataProps(props)}
    >
      {props.children}
    </Layout>
  );
};

Grid.displayName = 'Grid';
