import { setupShallowTest } from '../../tests/helpers';
import {
  Hero,
  HeroProps,
  testSelectors,
} from './component';

const imageSrc = 'Discover dark and brutal tombs';

function getRequiredProps(): HeroProps {
  return {
    imageSrc,
  };
}

const setupShallow = setupShallowTest(Hero, getRequiredProps);

describe('renders Editorial Detail with title', () => {
  it('renders alert-banner component', () => {
    const { wrapper } = setupShallow();

    expect(wrapper.find({ 'data-test-target': testSelectors.wrapper }).contains(imageSrc)).toBeTruthy();
  });
});
